---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：151-Cat ヘルス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御の具体的な権限名**：セキュリティプラグインのソースコード未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.health.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestHealthAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行152
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行190

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /_cat/health | E-01, E-02 行58 | ○ |
| C-02 | リクエストパラメータにformat, h, help, s, time, ts, vが存在 | E-01 params | ○ |
| C-03 | tsパラメータのデフォルトはtrue | E-01 ts.default | ○ |
| C-04 | 表示カラムにcluster, status, node.total等14項目 | E-02 行92-109 | ○ |
| C-05 | ClusterHealthRequestを使用してヘルス取得 | E-02 行78-80 | ○ |
| C-06 | ステータスはgreen/yellow/redの3値 | E-02 行119 toLowerCase(Locale.ROOT) | ○ |
| C-07 | max_task_wait_timeは0msの場合"-"を表示 | E-02 行129 | ○ |
| C-08 | active_shards_percentは%形式で表示 | E-02 行130 | ○ |
| C-09 | レスポンスは常に1行 | E-02 行117-131 (startRow/endRowが1回) | ○ |
| C-10 | allowSystemIndexAccessByDefaultがtrue | E-02 行67-69 | ○ |
| C-11 | 関連機能No.47 クラスタヘルス | E-04 | ○ |
| C-12 | discovered_cluster_managerカラムが存在 | E-02 行98-101 | ○ |
| C-13 | Cat APIシリーズとしてテーブル形式出力 | E-02 AbstractCatAction継承 | ○ |
| C-14 | 権限制御でcluster:monitor/health権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインの権限定義ソースコードを確認していないため、具体的な権限名が正確かは未検証
  - 候補：security plugin / roles mapping / action groups 定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様はREST API specとソースコードから直接確認済み
- 1: 中リスク - 権限制御の具体的な権限名については推定

## 6) レビュアーチェックリスト（最小）
- [ ] 表示カラムの一覧がソースコードのgetTableWithHeader()と一致しているか
- [ ] リクエストパラメータがcat.health.jsonの定義と一致しているか
- [ ] 権限制御に関する記述が正確か（セキュリティプラグイン設定を確認）
